#pragma once
#include "GameItems.h"

//SizeableItem is derived from GameItems. This allows us to create the same derived type of item but with different sizes (SpriteSize), making this more abstract.
//This also allows us to make a SizeableItem create function in ItemManager, rather than having to do create functions for pipe, cloud, hill, bush...

class SizeableItem :
	public GameItems
{
public:
	SizeableItem();
	~SizeableItem();

	virtual void create(SpriteSize size);	//Virtual function create overridden by each item, creates respective item of SpriteSize size

	static SizeableItem* currentItem;	//Static pointer SizeableItem, points to currentItem

protected:
	SpriteSize spriteSize;
};

